/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package overridingObjectClass;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestNewClass {
    public static void main(String[] args) {
        //Creating an instance of our newClass
        NewClass myClass = new NewClass();
        //Printing out an object
//        System.out.println(myClass);
        //Comparing two objects
        NewClass myClass2 = myClass;//Copy myClass into myClass2;
        NewClass myClass3 = new NewClass();//Create a new instance of NewClass()
        myClass2.content="New Content";
        myClass3.content="New Content";
        //Are myClass and myClass2 equal?
//        System.out.println("Are myClass and myClass2 equal? "+myClass.equals(myClass2));
        //Are myClass and myClass3 equal?
//        System.out.println("Are myClass and myClass2 equal? "+myClass.equals(myClass3));
        
        //Clarification - when we changed the content of myClass2, myClass also changed!
//        System.out.println("Content of myClass: "+myClass.content); 

        //Comparing primitives with ==
        int a=1;
        int b=1;
        int c=2;
        //Are a and b equal?
//        System.out.println("Are a and b equal? "+((a==b)?"true":"false"));
        //Are a and c equal?
//        System.out.println("Are a and c equal? "+((a==c)?"true":"false"));
        
        //Comparing objects with ==
        //Are myClass and myClass2 equal?
//        System.out.println("Are myClass and myClass2 equal? "+((myClass==myClass2)?"true":"false"));
        //Are myClass and myClass3 equal?
//        System.out.println("Are myClass and myClass3 equal? "+((myClass==myClass3)?"true":"false"));
        
        //Investigating hashcodes
        //A reminder that myClass and myClass 3 are equal according to the equals method.
        System.out.println("Are myClass and myClass2 equal? "+myClass.equals(myClass3));
        //But what about the hashCode?
        System.out.println("The hashCode for myClass is "+myClass.hashCode()+" but for myClass 3 it is "
                            +myClass3.hashCode());
        
        //Make sure that different content generates different hashCodes.
        myClass3.content="New Content ";
        System.out.println("The hashCode for myClass is "+myClass.hashCode()+" but for myClass 3 it is "
                            +myClass3.hashCode());
    }
}
